//Listing 14.15. Implementacja klasy Store (plik store.cpp)
// plik store.cpp

#include <iostream>
using namespace std;
#include "store.h" // to konieczno

void Store::loadData(Inventory &inv)
{ File itemsIn("Item.dat",ios::in); // baza danych obiektw
  char ttl[27], category; int id, qty, type; // dane obiektu
  cout << "Wczytywanie bazy danych ... " << endl;
  while (itemsIn.getItem(ttl,id,qty,category)==1) // odczytywanie
  { switch (category) { // ustaw kateegori dla podtypu
     case 'f': type = 1; break;
     case 'c': type = 2; break;
     case 'h': type = 3; break; }
    inv.appendItem(ttl,id,qty,type); }
  File custIn("Cust.dat",ios::in); // baza danych klientw
  char name[25], phone[15]; int movies[10], count;
  while (custIn.getCustomer(name,phone,count,movies)==1)
  { inv.appendCust(name,phone,count,movies); } } // odczytaj dane

int Store::findCustomer(Inventory& inv)
{ char buffer[200]; char name[25], phone[13];
  int count, movies[10];
  cout << "Podaj telefon klienta (lub wcinij Enter aby zakoczy prac) ";
  cin.getline(buffer,15);
  if (strcmp(buffer,"")==0) return 0; // jeli nie wprowadzono danych zakocz dziaanie
  bool found = false;
  while (inv.getCustomer(name,phone,count,movies) != 0)
   { if (strcmp(buffer,phone) == 0) // odszukaj telefon
      { found = true; break; } } // jeeli znaleziono zatrzymaj poszukiwanie
  if (!found)
    { cout << "\nKlient nie zosta odnaleziony " << endl;
      return 1; } // jeli nie odnalziono zrezygnuj z poszukiwa
  cout.setf(ios::left,ios::adjustfield);
  cout.width(22); cout << name << phone << endl; // wywietl dane
  for (int j = 0; j < count; j++)
    { inv.printRental(movies[j]);} // wywietl identyfikator filmu
  cout << endl;
  return 2; } // kod okreslajcy powodzenie

void Store::processItem(Inventory& inv)
{ int cmd, result, id;
  cout << " Podaj identyfikator filmu: ";
  cin >> id; // odszukaj atrybut
  cout << " Wprowad 1 aby wypoyczy, 2 zaby zwrci: ";
  cin >> cmd;
  if (cmd == 1)
    { result = inv.checkOut(id); // sprawd zwrcon warto
  if (result == 0) // nie zosta znaleziony
    cout << "Film nie zosta odnaleziony " << endl;
  else if (result == 1) // brak dostpnych
    cout << "Wszystkie filmy zostay wypoyczone " << endl;
  else // powodzenie
    cout << " Wypoyczenie zostao zatwierdzone \n"; }
  else if (cmd == 2)
    inv.checkIn(id); // wynik dziaania checkIn()
  cin.get(); } // usu z wiersza znak CR

void Store::saveData(Inventory &inv)
{ File itemsOut("Item.out",ios::out); Item item; // plik z filmami
  while (inv.getItem(item)) // brak wewntrznej struktury
  itemsOut.saveItem(item); // zapisz kady obiekt
  File custOut("Cust.out",ios::out); // plik wyjciowy z klientami
  char name[25], phone[13]; int count, movies[10];
  cout << "Zapisywanie bazy danych ... " << endl;
  while(inv.getCustomer(name,phone,count,movies)) // pobierz dane
  custOut.saveCustomer(name,phone,count,movies); }
